#include <DHT.h>                                                  //Βιβλιοθήκη αισθητήρα θερμοκρασίας/υγρασίας αέρα (DHT11)
#include <Liquid_Crystal.h>                                       //Βιβλιοθήκη οθόνης LCD

#define DHTPIN 5                                                  // Δήλωση της Θύρας δεδομένων του αισθητήρα (π.χ η θύρα εδώ είναι η D5)
#define DHTTYPE DHT11                                             // Τύπος αισθητήρα   (οι τύποι μπορεί να είναι ο DHT11:γαλάζιος ή ο DHT22:λευκός με μεγαλύτερη ακρίβεια)

DHT dht(DHTPIN, DHTTYPE);                                         // έναρξη αισθητήρα DHT

LiquidCrystal myLCD(0x27, 16, 2);                                 //Δήλωση της διεύθυνσης της οθόνης LCD. Η οθόνη πρέπει να είναι συνδεδεμένη στη θύρα I2C του Arduino

void setup() 
{
  myLCD.begin();                                                  // Εκκίνηση της LCD 
  dht.begin();                                                    // Εκκίνηση του αισθητήρα
}

void loop() 
{
  
  float humidity = dht.readHumidity();                              // Ανάγνωση υγρασίας
  float temperature = dht.readTemperature();                        // Ανάγνωση θερμοκρασίας

  
  if (isnan(humidity) || isnan(temperature)) 
  {
    Serial.println("Error reading");                                // Έλεγχος αν η ανάγνωση από τον αισθητήρα ήταν επιτυχής
  } 
  
  else 
  {
    // Εμφάνιση υγρασίας στην πρώτη γραμμή της LCD
    myLCD.Text("H:     ", 0, 0);
    myLCD.Text(String(humidity,0).c_str(), 2, 0);
    myLCD.Text("%", 7, 0);

    // Εμφάνιση θερμοκρασίας στη δεύτερη γραμμή της LCD
    myLCD.Text("T:     ", 0, 1);
    myLCD.Text(String(temperature,0).c_str(), 2, 1);
    myLCD.Text("C", 7, 1);
  }

  delay(500);                                                       // Καθυστέρηση 0.5 δευτερολέπτων
}
